<?php 
include ("core/init.inc.php");

$errors = array();

if (isset($_POST['username'], $_POST['password'])){
	if (empty($_POST['username'])){
		$errors[] = 'The username cannot be empty.';
	}
	
	if (empty($_POST['password'])){
		$errors[] = 'The password cannot be empty.';
	}
	
	if (valid_credentials($_POST['username'], sha1($_POST['password'])) === false){
		$errors[] = 'Username / Password incorrect.';
	}
	
	if (empty($errors)){
		$_SESSION['username'] = htmlentities($_POST['username']);
		header('Location: protected.php');
		die();	
	}
}

?>
<!DOCTYPE html>
<html>
<head>
<?php include('inc/meta.php'); ?>

<!-- <link href="calendar/calendar.css" rel="stylesheet" type="text/css" /> -->
</head>
<body>


<div>
<?php 

if (empty($errors) === false){
	?>
	<ul>
		<?php
			
		foreach ($errors as $error){
			echo "<li>{$error}</li>";
		}		
		
		?>
	</ul>
	<?php
}

?>
</div>
<div class="login-header">
	<div class="wrapper container">
		<img src="assets/img/logo.png" width="350" alt="Logo" title="Essex Digital Media Logo">
	</div>
</div>
<div class="wrapper container" style="position:relative;">
<div class="edm-panel">
<div class="edm-panel-inner">
	<form action="" method="post" class="login">
	<h2 class="text-center">CRMS</h2>
		<p>
			<label for="username">Username:</label>
			<input type="text" name="username" id="username">
		</p>
		<p>
			<label for="password">Password:</label>
			<input type="password" name="password" id="password">
		</p>
		<p>
			<input type="submit" value="Login" style="margin-right:15px;"> <span style="float:right; margin-top:10px; color:#777;">Can't Login? <a href="mailto:design@essexdigitalmedia.co.uk">Click Here</a></span>
		</p>
	</form>
</div>
<a href="https://design.essexdigitalmedia.co.uk/login.php" class="designbutton">Enter DSN Portal</a>
<a href="http://essexdigitalmedia.co.uk/seo/login.php" class="seobutton">Enter SEO Portal</a>
</div>
</div>
<?php include('inc/footer.php'); ?>
</body>
</html>