<?php 
include ("core/init.inc.php");

function date_picker($name, $startyear=NULL, $endyear=NULL) {
    if($startyear==NULL) $startyear = date("Y");
    if($endyear==NULL) $endyear=date("Y")+1; 

    $months=array('','January','February','March','April','May',
    'June','July','August', 'September','October','November','December');

    // Day dropdown
    $html="<select name=\"".$name."day\">";
    for($i=1;$i<=31;$i++)
    {
       $html.="<option $selected value='$i'>$i</option>";
    }
    $html.="</select> ";
	
	// Month dropdown
    $html.="<select name=\"".$name."month\">";

    for($i=1;$i<=12;$i++)
    {
       $html.="<option value='$i'>$months[$i]</option>";
    }
    $html.="</select> ";

    // Year dropdown
    $html.="<select name=\"".$name."year\">";

    for($i=$startyear;$i<=$endyear;$i++)
    {      
      $html.="<option value='$i'>$i</option>";
    }
    $html.="</select> ";

    return $html;
}
?>

<!DOCTYPE html>
<html>
<head>
<?php include('inc/meta.php'); ?>
</head>
<body>
	<?php include('inc/header.php'); ?>
<div class="wrapper container">
	<h2>Add Client</h2>
	<div id="details">
		<?php
		if (isset($_POST['submit'])) {
	
			$client_name 			= $_POST['client_name'];
			$client_company_name	= $_POST['client_company_name'];
			$client_telephone		= $_POST['client_telephone'];
			$client_mobile			= $_POST['client_mobile'];
			$client_email			= $_POST['client_email'];
			$selmonth 				= $_POST['addclientmonth'];
			$selday 				= $_POST['addclientday'];
			$selyear 				= $_POST['addclientyear'];
			$selhour 				= $_POST['client_hour'];
			$selminute 				= $_POST['client_minute'];
			$client_callback_time	= $_POST['client_callback_time'];
			$client_address			= $_POST['client_address'];
			$client_website			= $_POST['client_website'];
			$client_notes			= $_POST['client_notes'];
			$client_quote			= $_POST['client_quote'];
			$client_status			= $_POST['client_status'];
			$client_appointment_date	= $_POST['client_appointment_date'];
			$client_appointment_time	= $_POST['client_appointment_time'];
			$client_staff_name		= $_SESSION['username'];
	
			if (empty($client_name)) {
				echo '<strong class="error">Client Name cannot be empty!</strong>';
			} else if (empty($client_company_name)) {
				echo '<strong class="error">Company Name cannot be empty!</strong>';
			} else {
	
	            global $conn;
				mysqli_query($conn, 
					"INSERT INTO `clients` (
						`client_name`,
						`client_company_name`,
						`client_telephone`,
						`client_mobile`,
						`client_email`,
						`client_callback_date`,
						`client_callback_time`,
						`client_appointment_date`,
						`client_appointment_time`,
						`client_address`,
						`client_website`,
						`client_quote`,
						`client_notes`,
						`client_status`,
						`client_staff_name`,
						`client_added_on`
					) VALUES (
						'{$client_name}',
						'{$client_company_name}',
						'{$client_telephone}',
						'{$client_mobile}',
						'{$client_email}',
						'{$selyear}-{$selmonth}-{$selday}',
						'{$selhour}:{$selminute}:00',
						'{$client_appointment_date}',
						'{$client_appointment_time}',
						'{$client_address}',
						'{$client_website}',
						'{$client_quote}',
						'{$client_notes}',
						'{$client_status}',
						'{$client_staff_name}',
						''
					)
				");				
			}
		}
		?>
		<form action="" method="post">
		<legend>Client Details</legend>
		<div class="row">
		<div class="col-md-4">
			<!-- Name -->
			<p><label for="client_name">Name</label>
			<input type="text" name="client_name"></p>
		</div>
		<div class="col-md-4">
			<!-- Company Name -->
			<p><label for="client_company_name">Company Name</label>
			<input type="text" name="client_company_name"></p>
		</div>
		<div class="col-md-4">			
			<!-- Telephone -->
			<p><label for="client_telephone">Telephone</label>
			<input type="text" name="client_telephone"></p>
		</div>
		</div>
		<div class="row">
		<div class="col-md-4">
			<!-- Mobile -->
			<p><label for="client_mobile">Mobile</label>
			<input type="text" name="client_mobile"></p>
		</div>
		<div class="col-md-4">				
			<!-- Email -->
			<p><label for="client_email">Email</label>
			<input type="text" name="client_email"></p>
		</div>
		<div class="col-md-4">				
			<!-- Address -->
			<p><label for="client_address">Address</label>
			<input type="text" name="client_address"></p>
		</div>
		</div>

		<div class="row">
			<div class="col-md-4 col-sm-6">				
			<!-- Website -->
			<label for="client_website">Website URL</label>
			<input type="text" name="client_website" value="">
			</div>
		</div>

		<div class="row">
		<div class="col-md-6"><legend>Callback Details</legend>
		<div class="row">
		<div class="col-md-6">
			<!-- Callback Date -->
			<p><label for="client_callback_date">Callback Date</label>
			<span class="addprojectdate"><?php echo date_picker('addclient'); ?></span></p>
		</div>
		<div class="col-md-6">
			<!-- Callback Time -->
			<p><label for="client_callback_time">Callback Time</label>
			<span class="addprojecttime"><select name="client_hour">
				<option>09</option>
				<option>10</option>
				<option>11</option>
				<option>12</option>
				<option>13</option>
				<option>14</option>
				<option>15</option>
				<option>16</option>
				<option>17</option>
				<option>18</option>
			</select>
			<select name="client_minute">
				<option>00</option>
				<option>15</option>
				<option>30</option>
				<option>45</option>
			</select></span></p>
		</div>
		</div>
		</div>
		<div class="col-md-6">
			<legend>Appointment Details</legend>
			<div class="row">
				<div class="col-md-6">
					<!-- Mobile -->
					<p><label for="client_appointment_date">Appointment Date</label>
					<input type="text" name="client_appointment_date"></p>
				</div>
				<div class="col-md-6">
					<!-- Mobile -->
					<p><label for="client_appointment_time">Appointment Time</label>
					<input type="text" name="client_appointment_time"></p>
				</div>
			</div>
		</div>
		</div>			
			<div class="row">
				<div class="col-md-6">
			<!-- Notes -->
			<p><label for="client_notes">Notes</label>
			<textarea name="client_notes" class="notes"></textarea></p>
				</div>
				<div class="col-md-6">
						<!-- Notes -->
			<p><label for="client_quote">Quote</label>
			<textarea name="client_quote" class="notes"></textarea></p>
			</div>
			</div>
			<!-- Status -->
			<p><label for="client_status">Status</label><br />
			<select name="client_status">
				<option>Prospect</option>
				<option>Red Hot</option>
				<option>Sold</option>
				<option>Dead</option>
			</select></p>
			
			<!-- Submit -->
			<input type="submit" name="submit">
		</div>
		<div class="clear"></div>
	</form>
</div>
</div>
<?php include('inc/footer.php'); ?>


</body>
</html>